#!/bin/bash
# Creates a credential-free backup for sharing with new users
echo "Creating clean backup for new user..."
cd ~
cp -r moltbot-research /tmp/moltbot-clean
# Blank credentials
cat > /tmp/moltbot-clean/.env << 'CREDS'
# REPLACE WITH YOUR CREDENTIALS
RH_USERNAME=XXXX
RH_PASSWORD=XXXX
CREDS
chmod 600 /tmp/moltbot-clean/.env
# Remove logs and personal data
rm -f /tmp/moltbot-clean/scanner_log.csv
rm -f /tmp/moltbot-clean/executed_trades.csv
rm -f /tmp/moltbot-clean/positions.csv
rm -f /tmp/moltbot-clean/daily_pnl.csv
rm -f /tmp/moltbot-clean/day_trades.json
rm -f /tmp/moltbot-clean/signals.md
rm -f /tmp/moltbot-clean/pending_trades.md
rm -f /tmp/moltbot-clean/scanner_cron.log
rm -f /tmp/moltbot-clean/ntfy_log.txt
rm -rf /tmp/moltbot-clean/memory/
mkdir -p /tmp/moltbot-clean/memory
rm -f /tmp/moltbot-clean/moltbot-backup-*.tar.gz
# Blank USER.md
cat > /tmp/moltbot-clean/USER.md << 'USR'
# User Profile
- Name: XXXX
- Timezone: XXXX (e.g., US Arizona no DST)
- Relationship: Work only
USR
# Create tar
tar czf ~/moltbot-research/moltbot-newuser-$(date +%Y%m%d).tar.gz -C /tmp moltbot-clean --transform='s/moltbot-clean/moltbot-research/'
rm -rf /tmp/moltbot-clean
echo "Done: ~/moltbot-research/moltbot-newuser-$(date +%Y%m%d).tar.gz"
echo "Share this + moltbot-setup.sh with new user."
