#!/usr/bin/env python3
"""
Patch market_scanner.py to log ntfy messages.
Run: python3 patch_scanner_ntfy.py
"""

filepath = "/home/mm/moltbot-research/market_scanner.py"

with open(filepath, "r") as f:
    content = f.read()

old_ntfy = '''def send_ntfy(message, priority="default"):
    """Send ntfy notification."""
    try:
        cmd = [
            "curl", "-s",
            "-H", f"Priority: {priority}",
            "-d", message,
            f"https://ntfy.sh/{NTFY_TOPIC}"
        ]
        subprocess.run(cmd, capture_output=True, timeout=10)
    except Exception as e:
        print(f"ntfy error: {e}")'''

new_ntfy = '''NTFY_LOG = os.path.join(WORKSPACE, "ntfy_log.txt")

def send_ntfy(message, priority="default"):
    """Send ntfy notification and log locally."""
    # Log locally first
    try:
        with open(NTFY_LOG, "a") as f:
            f.write(f"[{datetime.now(timezone.utc) + AZ_OFFSET:%Y-%m-%d %H:%M:%S}] [scanner] {message}\\n")
    except Exception as e:
        print(f"ntfy log write failed: {e}")

    # Send notification
    try:
        cmd = [
            "curl", "-s",
            "-H", f"Priority: {priority}",
            "-d", message,
            f"https://ntfy.sh/{NTFY_TOPIC}"
        ]
        subprocess.run(cmd, capture_output=True, timeout=10)
    except Exception as e:
        print(f"ntfy error: {e}")'''

content = content.replace(old_ntfy, new_ntfy)

with open(filepath, "w") as f:
    f.write(content)

print("✓ market_scanner.py patched - ntfy messages now logged to ntfy_log.txt")
